#!/bin/sh

DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
DPLY_PAGE_ESXI_INFO_CONF_RESULT_OK=0
DPLY_PAGE_ESXI_INFO_CONF_RESULT_ERROR=1

DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE=${DPLY_PAGE_ESXI_INFO_CONF_RESULT_ERROR}
DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0


dply_page_esxi_info_conf() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    # assign default value
    [ -z "${RT_ESXI_IP}" ]       && RT_ESXI_IP="${conf_esxi_ip}"
    [ -z "${RT_ESXI_USERNAME}" ] && RT_ESXI_USERNAME="${conf_esxi_username}"
    [ -z "${RT_ESXI_PASSWORD}" ] && RT_ESXI_PASSWORD="${conf_esxi_password}"
    
    
    tp_username_password \
        "${DPLY_PAGE_ESXI_INFO_CONF_TITLE}" \
        "${DPLY_PAGE_ESXI_INFO_CONF_TEXT}" \
        "${DPLY_PAGE_ESXI_INFO_CONF_LABEL_OK}" \
        "${DPLY_PAGE_ESXI_INFO_CONF_LABEL_CANCEL}" \
        "${RT_ESXI_USERNAME}" \
        "${RT_ESXI_PASSWORD}"
        
        
    debug_print "TP_USERNAME_PASSWORD_RESULT_CODE: ${TP_USERNAME_PASSWORD_RESULT_CODE}"
    case "${TP_USERNAME_PASSWORD_RESULT_CODE}" in
    
        "${TP_USERNAME_PASSWORD_RESULT_ERROR}")
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_ERROR
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG="${TP_USERNAME_PASSWORD_RESULT_MSG}"
            return
            ;;
        
        "${TP_USERNAME_PASSWORD_RESULT_CANCEL}")
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_OK
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=-2
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
            return
            ;;
            
        "${TP_USERNAME_PASSWORD_RESULT_OK}" )
            ;;
        
        *)
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_ERROR
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
            DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG="${DPLY_PAGE_ESXI_INFO_CONF_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    # check esxi connection
    local ret
    local msg
    msg=`/usr/bin/esxcli \
        --server   "${RT_ESXI_IP}" \
        --username "${TP_USERNAME_PASSWORD_RESULT_USERNAME}" \
        --password "${TP_USERNAME_PASSWORD_RESULT_PASSWORD}"`
    ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        debug_print "TerminateByCtrlC: ret='${ret}'"
        
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE="${DPLY_PAGE_ESXI_INFO_CONF_RESULT_OK}"
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
        return

    elif [ "${ret}" -eq 1 ] && [[ "${msg}" =~ "Connection failure" ]]; then
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE="${DPLY_PAGE_ESXI_INFO_CONF_RESULT_ERROR}"
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG="${ERROR_ESXI_WRONG_SERVER_UNAVAILABLE}"
        return

    elif [ "${ret}" -ne 0 ]; then
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE="${DPLY_PAGE_ESXI_INFO_CONF_RESULT_ERROR}"
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG="${ERROR_ESXI_WRONG_USERNAME_PASSWORD}"
        return
    fi
    
    # save and error handling
    utility_save_esxi_conf \
        "${RT_ESXI_IP}" \
        "${TP_USERNAME_PASSWORD_RESULT_USERNAME}" \
        "${TP_USERNAME_PASSWORD_RESULT_PASSWORD}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_ERROR
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG="${DPLY_PAGE_ESXI_INFO_CONF_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_ESXI_CONF_RESULT_MSG}"
        return
    fi
    

    # apply successfully
    RT_ESXI_USERNAME="${TP_USERNAME_PASSWORD_RESULT_USERNAME}"
    RT_ESXI_PASSWORD="${TP_USERNAME_PASSWORD_RESULT_PASSWORD}"
    
    DPLY_PAGE_ESXI_INFO_CONF_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_OK
    DPLY_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=1
    DPLY_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
}